# Entry point to reproduce the collisional-decoherence runs
import argparse, json, math, numpy as np, pandas as pd
from pathlib import Path
from v2cd.sim import run_sim_grid

def parse_args():
    ap = argparse.ArgumentParser(description="Present‑Act V2 — Collisional Decoherence (Boolean which‑path marks)")
    ap.add_argument("--outdir", type=str, default="outputs", help="Directory to write CSV/JSON outputs")
    ap.add_argument("--k-per-seed", type=int, default=50000, help="Trials per (p,N) per seed")
    ap.add_argument("--seeds", type=int, nargs="+", default=[101,202,303], help="Seed list")
    ap.add_argument("--p", type=float, nargs="+",
                    default=[0.0,0.005,0.01,0.02,0.04,0.06,0.08,0.10],
                    help="Per-opportunity mark probabilities")
    ap.add_argument("--N", type=int, nargs="+", default=[10,25,50,100], help="Number of opportunities (columns)")
    return ap.parse_args()

def main():
    args = parse_args()
    outdir = Path(args.outdir)
    outdir.mkdir(parents=True, exist_ok=True)
    results = run_sim_grid(p_list=args.p, N_list=args.N, K_per_seed=args.k_per_seed, seeds=args.seeds, outdir=outdir)
    print("Wrote:", results)

if __name__ == "__main__":
    main()
